

install.packages("ggplot2")
install.packages("bcrm")
#install.packages("devtools")
devtools::install_github("anirban0451/tpidesigns", build_vignettes = TRUE, 
                         build_opts = c("--no-resave-data", "--no-manual"),force = TRUE)
install.packages("BOIN")
install.packages("clinfun")
install.packages("MCPMod")



library(ggplot2)
library(bcrm)
library(tpidesigns)
library(BOIN)
library(clinfun)
library(MCPMod)


### Phase I ###
##### CRM, mCRM #####


#patient = 1:42
dose.label <- c(5, 10, 15, 25, 30, 40, 50)
p.tox0 <- c(0.05, 0.10, 0.20, 0.30, 0.35, 0.40, 0.45)

#### CRM ###
#### 設定劑量反應曲線的模型形式，
### 設定模型參數 alpha 的先驗分佈。對於 power model，這通常是一個 Gamma 分佈的參數 ###

trial.crm <- bcrm(stop = list(nmax = 12), p.tox0 = p.tox0, dose = dose.label,
                     ff = "power", prior.alpha = c(1, 1, 1), target.tox = 0.33,
                     constrain = FALSE, plot=TRUE, cohort = 1,pointest = "plugin",
                     method="exact") 
                               
plot(trial.crm,trajectory = TRUE)
print(trial.crm)


#### mCRM ###
### 對模型參數施加約束 (TRUE)，以確保模型行為更穩定、合理，避免極端估計值 ###

trial.mcrm <- bcrm(stop = list(nmax = 30), p.tox0 = p.tox0, dose = dose.label,
                     ff = "power", prior.alpha = c(1, 1, 1), target.tox = 0.33,
                     constrain = TRUE,plot=TRUE,cohort = 3,pointest = "plugin", 
                     method="exact",start=1)          


plot(trial.mcrm,trajectory = TRUE)
print(trial.mcrm)



############################
##  TPI改成shiny ##
###########################
##### TPI, mTPI, mTPI-2 ####



####### BOIN #####

#### Obtain dose escalation and de-escalation boundaries ####
bound <- get.boundary(target = 0.3, ncohort = 10, cohortsize = 3)
summary(bound)
plot(bound)

# When the trail is completed, based on the observed data, 
# we can select the MTD.  
### select MTD ####

n <- c(1,1,8,17,0)
x <- c(0,0,1,5,0)
selmtd <- select.mtd(target=0.3, npts=n, ntox=x)
summary(selmtd)
plot(selmtd)





###################
#### Phase II ####
##### Simon's 2 stages #####

#ph2simon(p0, p1, α, β)
ph2simon(0.2, 0.4, 0.05, 0.1)




####  MCP-MOD procedure #####
##### parameter estimation ####

guesst(d = 0.2, p = 0.9, model = "emax")
guesst(d = c(0.05, 0.2), p = c(0.2, 0.9), model = "logistic")


### model plots ####

models <- list(linear = NULL, emax = c(25),                                
               logistic = c(50, 10.88111), exponential = c(85),            
               betaMod = matrix(c(0.33, 2.31, 1.39, 1.39), byrow=TRUE,nrow=2))

doses <- c(0, 10,25,50,100,150)
plotModels(models, doses, base = 0, maxEff = 0.4, scal = 200,cex=1,lwd=2)


#### the model contrasts and critical value ######

plM <- planMM(models, doses, n = rep(60,6), scal=200, alpha = 0.05)
plM


#### sample size calculation ####

sampSize(models, doses, base = 0, maxEff = 0.4, sigma = 1,             
         upperN = 80, scal = 200, alpha = 0.05)




######### Example 2 #################
# analyzing a trial

data(biom)

doses <- c(0, 0.05, 0.2, 0.6, 1)
mods2 <- list(linear = NULL, emax = c(0.05, 0.2), betaMod = c(0.5, 1),
              logistic = matrix(c(0.25, 0.7, 0.09, 0.06), byrow = FALSE,
                                nrow = 2))
plotModels(mods2, doses, base = 0, maxEff = 0.4, scal = 200,lwd=2) 

# dePar = 0.05,檢出限參數：Detection Edge Parameter，通常用於調整模型的檢出力或敏感性參數，此處設為 0.05。
### doseEst, 劑量估計方法：指定估計目標。
# "MED" 代表 Minimum Effective Dose（最小有效劑量）。
# "MED2" 通常表示在考慮到臨床相關性閾值後，估計最小有效劑量。
# clinRel = 0.4, 臨床相關性閾值：當 doseEst 設為 "MED2" 時使用。定義一個臨床上認為足夠顯著的最小療效差異（例如 0.4）。
# off = 1,偏移量：通常是技術性的參數，用於內部計算調整。


dfe <- MCPMod(biom, mods2, alpha = 0.05, dePar = 0.05, pVal = TRUE,
              selModel = "maxT", doseEst = "MED2", clinRel = 0.4, off = 1)
summary(dfe)

# plots data with selected model function
plot(dfe, complData = TRUE, cR = TRUE,lwd=2)



